﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;

namespace FS28BluetoothSlaveModeDemo
{
    [StructLayout(LayoutKind.Sequential)]
    public struct FTRIMGPARMS
    {
        public uint Width;       // image Width
        public uint Height;      // image Height
        public uint DPI;         // resolution Dots per inch
        public uint RAW_size;    // size of RAW image
        public uint BMP_size;    // size of BMP image
        public uint WSQ_size;    // size of WSQ image
        public float Bitrate;     // compression
    }

    class FtrWSQ
    {
        /*
          ftrWSQ_GetImageParameters    - load WSQ parameters[Width,Height...] from WSQ image
          please call it before ftrWSQ_ToRawImage for allocate right size of memory for output file
          Args  
                    ftrWSQbuf       [in]    - pointer to WSQ image
                    ImPar.WSQ_size  [in]
                    ImPar           [out]   - pointer to FTRIMGPARMS structure
          Return                       - TRUE is OK, FALSE - error
        */
        [DllImport("ftrWSQ.dll")]
        public static extern int ftrWSQ_GetImageParameters(byte[] ftrWSQbuf, ref FTRIMGPARMS ftrImPar);
        /*
          ftrWSQ_GetDQTTable       - load WSQ parameters[Width,Height,DQTTable,o_quant,...] from WSQ image
          for WSQ compliance only
          Args  
                    ftrWSQbuf  [in]    - pointer to WSQ image
                    ImPar.WSQ_size [in]
                    ImPar      [out]   - pointer to FTRIMGPARMS structure
                    DQTTable    [out]
                    o_quant     [out]
                    o_size      [out]
          Return                       - TRUE is OK, FALSE - error
        */
        [DllImport("ftrWSQ.dll")]
        public static extern int ftrWSQ_GetDQTTable(byte[] ftrWSQbuf, FTRIMGPARMS ftrImPar, ref float DQTTable, ref int o_quant, ref int o_size);

        /*
          WSQ_ToRawImage                - convert image from WSQ format ?RAW format
			         ftrWSQbuf  [in]    -  pointer to WSQ image
                     ImPar.WSQ_size [in] - size of WSQ image
                     ImPar      [out]   - pointer to FTRIMGPARMS structure
                     RAWbuf     [out]   -  pointer to RAW image with size RAW_size after WSQ_GetImageParameters
          Return                        - TRUE is OK, FALSE - error
        */
        [DllImport("ftrWSQ.dll")]
        public static extern int ftrWSQ_ToRawImage(byte[] ftrWSQbuf, ref FTRIMGPARMS ftrImPar, byte[] RAWbuf);

        /*
          WSQ_FromRAWImage                      - Convert image from RAW(8bit grayscale) ?WSQ
			         RAWbuf         [in]        - pointer to RAW image
                     ImPar.Width    [in]
                     ImPar.Height   [in]
                     ImPar.DPI      [in]
                     ImPar.Bitrate  [in]
                     ImPar.WSQ_size [out]       - pointer to FTRIMGPARMS structure
                     ftrWSQbuf      [out]       - pointer to WSQ image ,size must be  same as RAWbuf
          Return                                - TRUE is OK, FALSE - error
        */
        [DllImport("ftrWSQ.dll")]
        public static extern int ftrWSQ_FromRAWImage(IntPtr ftrHandle, byte[] RAWbuf, ref FTRIMGPARMS ftrImPar, byte[] ftrWSQbuf);
    }
}